REM [Сетевые настройки]
REM SET eth-fDhcp        = 0              REM Автоматическое получение ip-адреса (DHCP): 0 - выкл., 1 - вкл.
REM SET eth-ip           = 192.168.0.127  REM ip-адрес сетевого интерфейса контроллера. (!) Используется только если отключено DHCP, см. выше.
REM SET eth-mask         = 255.255.255.0  REM Маска подсети
REM SET eth-gw           = 192.168.0.1    REM ip-адрес шлюза (роутера), необходим для доступа контроллера к Интернет

REM [Конфигурация типа установки]
SET sys-fIsWater             = 0      REM Тип установки, 0 - с электронагревателем, 1 - с водяным нагревателем
SET sys-fUseTwoHeater        = 0      REM Использование второй ступени электронагревателя, 0 - нет (1 ступень), 1 - да (две ступени)

REM [Настройки алгоритма управления установкой]
SET algo-tempControl         = 0      REM Регулирование температуры: 0 - по датчику канала; 1 - каскадное
SET algo-tempRertunWaterWait = 30     REM Температура обратной воды в режиме ожидания (для режима Водяной нагрев) [15...40]
SET algo-timeOpenDamper      = 30     REM Время открытия заслонки, сек. [5...90]
SET algo-timeAccelerFan      = 10     REM Время разгона вентилятора, сек. [1...60]
SET algo-timeBlowHeat        = 10     REM Время продува ТЭНов, сек. [1...60]
SET algo-fan1SpeedMax        = 100    REM Максимальная скорость приточного вентилятора в % [20...100]
SET algo-fan1SpeedMin        = 20     REM Минимальная скорость приточного вентилятора в % [1...90]
SET algo-fan2SpeedMax        = 100    REM Максимальная скорость вытяжного вентилятора в % [20...100]
SET algo-fan2SpeedMin        = 20     REM Минимальная скорость вытяжного вентилятора в % [1...90]
SET algo-filterEn            = 1      REM Наличие фильтра  0 - выкл., 1 - вкл.
SET algo-heatPwmPeriod       = 30     REM Период ШИМ ТЭНа (для режима Электрический нагрев) [2...60]
SET algo-piKofP              = 33     REM Пропорциональный коэффициент ПИ регулятора [0...255]
SET algo-piKofI              = 100    REM Интегральный коэффициент ПИ регулятора [0...255]
SET algo-piErr               = 0      REM Зона нечувствительности ПИ регулятора [0...255]
SET algo-pi2KofP             = 33     REM Пропорциональный коэффициент второго ПИ регулятора [0...255]
SET algo-pi2KofI             = 100    REM Интегральный коэффициент второго ПИ регулятора [0...255]
SET algo-pi2Err              = 0      REM Зона нечувствительности второго ПИ регулятора [0...255]
SET algo-autoStartEn         = 1      REM Автоматический старт установки: 0 - выкл., 1 - вкл.
SET algo-isDistPower         = 0      REM Дистанционное управлением питанием: 0 - выкл., 1 - вкл.
SET algo-modeZimaLetoSource  = 1      REM Управление режимом Зима/Лето. 0 – пользовательское, задается параметром modeZimaLetoUser; 1 - по значению датчика температуры воздуха на улице «T.внеш». Параметр актуален для установок с водяным калорифером.
SET algo-modeZimaLetoUser    = 0      REM Режим Зима/Лето задаваемый пользователем. 0 – Зима. 1 – Лето.
SET algo-modeZimaLetoTemp    = 16     REM Температура воздуха на улице для переключения режима «Зима/Лето» [0..30]
SET algo-modeZimaLetoGist    = 1      REM Гистерезис температуры воздуха на улице для переключения режима «Зима/Лето». [1..5]
SET algo-timeWarmUp          = 3      REM Время прогрева калорифера при включении установки, мин. [0..255]
SET algo-timeDefrost         = 3      REM Время разморозки калорифера. [0..255]
SET algo-alarmRestartCount   = 5      REM Кол-во аварийных перезапусков установки, при достижении которых, установка останавливается. [0..10]
SET algo-nanosRollTime       = 0      REM Время периодической прокачки насоса в минутах при выключенной установке. Используется для снижения энергопотребления. [0..30]
SET algo-usePwmBresem        = 0      REM Использовать алгорит Брезенхема в формировании ШИМ сигнала, 0 - нет, 1 - да.

REM [Доступ к веб-интерфейсу через ЛВС]
REM SET http-fPr         = 0              REM Использовать пароль для доступа к веб-интерфейсу (только чтение): 0 - выкл., 1 - вкл.
REM SET http-pr          = 0000           REM Пароль для доступа с уровнем Только чтение
REM SET http-fPu         = 0              REM Использовать пароль для доступа к веб-интерфейсу (пользователь): 0 - выкл., 1 - вкл.
REM SET http-pu          = 1111           REM Пароль для доступа с уровнем Пользователь
REM SET http-fPw         = 0              REM Использовать пароль для доступа к веб-интерфейсу: 0 - выкл., 1 - вкл.
REM SET http-pw          = 2222           REM Пароль для доступа к веб-интерфейсу

REM [Modbus Slave]
SET mb-fTcp          = 0              REM Использовать Modbus TCP: 0 - выкл., 1 - вкл.
SET mb-fRtu          = 0              REM Использовать Modbus RTU: 0 - выкл., 1 - вкл.
SET mb-addr          = 77             REM Modbus адрес контроллера [1...248]
SET mb-speed         = 5              REM RTU битрейд: 0-300, 1-600, 2-1200, 3-2400, 4-4800, 5-9600, 6-14400, 7-19200, 8-38400, 9-56000, 10-57600, 11-115200
SET mb-parity        = 2              REM RTU четность: 0-NONE, 1-EVEN, 2-ODD
SET mb-delay         = 0              REM RTU задержка ответа, мс

REM [Прочие настройки]
SET others-fDebug    = 0              REM Отладочный режим (для разработчиков): 0 - выкл., 1 - вкл.
SET others-fTest     = 0              REM Режим тестирования, используется в веб-интерфейсе: 0 - выкл., 1 - вкл.
SET others-ntcFilter = 5              REM Период фильтра NTC [1..30]
REM SET others-loc       =                REM Имя контроллера

REM [Подключение к серверу]
SET srv-fEn       = 1                 REM Использовать: 0 - выкл., 1 - вкл.
SET srv-fMetric   = 1                 REM Хранить метрики и события на сервере: 0 - выкл., 1 - вкл.


REM [Конфигурация времени]
SET time-fSntp       = 0              REM Автоматическая настройка времени (SNTP): 0 - выкл., 1 - вкл.
SET time-ip          = 46.188.16.150  REM ip-адрес сервера для получения времени по SNTP
SET time-zone        = 3              REM Часовой пояс GMT [-14...14]
SET time-calib       = 0              REM Коррекция, сек/mec [0..255]
REM SET time-unix        =                REM Задание времени в формате Unix

REM [Конфигурация аварий]
SET alarm1-en        = 1              REM Авария приточного вентилятора (DI1) активна: 0 - выкл., 1 - вкл.
SET alarm1-action    = 1              REM Реакция на аварию: 0 - нет, 1 - останов установки, 2 - рестарт установки
SET alarm1-delay     = 10             REM Задержка на регистрацию аварии, сек.
SET alarm2-en        = 1              REM Авария вытяжного вентилятора (DI2) активна: 0 - выкл., 1 - вкл.
SET alarm2-action    = 1
SET alarm2-delay     = 10             REM Задержка на регистрацию аварии, сек.
SET alarm3-en        = 1              REM Угроза замерзания по термостату/перегрев электронагревателя (DI3): 0 - выкл., 1 - вкл.
SET alarm3-action    = 1
SET alarm3-delay     = 10             REM Задержка на регистрацию аварии, сек.
SET alarm4-en        = 1              REM Засорение входного фильтра (DI4): 0 - выкл., 1 - вкл.
SET alarm4-action    = 1
SET alarm4-delay     = 10             REM Задержка на регистрацию аварии, сек.
SET alarm5-en        = 1              REM Пожарная тревога (DI5): 0 - выкл., 1 - вкл.
SET alarm5-action    = 1
SET alarm5-delay     = 10             REM Задержка на регистрацию аварии, сек.
SET alarm6-en        = 1              REM Ошибка датчика температуры в канале (NTC1): 0 - выкл., 1 - вкл.
SET alarm6-action    = 1
SET alarm6-delay     = 10             REM Задержка на регистрацию аварии, сек.
SET alarm7-en        = 1              REM Ошибка датчика температуры обратной воды (NTC3): 0 - выкл., 1 - вкл.
SET alarm7-action    = 1
SET alarm7-delay     = 10             REM Задержка на регистрацию аварии, сек.
SET alarm8-en        = 1              REM Температура меньше допустимой: 0 - выкл., 1 - вкл.
SET alarm8-action    = 1
SET alarm8-delay     = 10             REM Задержка на регистрацию аварии, сек.
SET alarm8-value     = 10             REM Значение температуры, град. [5...20]
SET alarm9-en        = 1              REM Температура больше допустимой: 0 - выкл., 1 - вкл.
SET alarm9-action    = 1
SET alarm9-delay     = 10             REM Задержка на регистрацию аварии, сек.
SET alarm9-value     = 45             REM Значение температуры, град. [5...70]
